/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.xhr;

import com.aptana.js.debug.core.model.xhr.IXHRTransfer;
import com.aptana.js.debug.ui.internal.xhr.Messages;
import com.aptana.js.debug.ui.internal.xhr.XHRContentProvider;
import com.aptana.js.debug.ui.internal.xhr.XHRLabelProvider;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.Page;

public class AJAXMonitorPage
extends Page {
    private Control mainControl;
    private TableViewer tableViewer;
    private Viewer[] requestData = new Viewer[2];
    private Viewer[] responseData = new Viewer[2];

    public void createControl(Composite parent) {
        SashForm hSashForm = new SashForm(parent, 512);
        hSashForm.setLayoutData((Object)new GridData(1808));
        hSashForm.setBackgroundMode(1);
        this.createRequestsTable((Composite)hSashForm);
        SashForm vSashForm = new SashForm((Composite)hSashForm, 256);
        vSashForm.setLayoutData((Object)new GridData(1808));
        this.createDetailsPart((Composite)vSashForm, Messages.AJAXMonitorPage_Request, this.requestData);
        this.createDetailsPart((Composite)vSashForm, Messages.AJAXMonitorPage_Response, this.responseData);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IXHRTransfer xhr = (IXHRTransfer)((IStructuredSelection)selection).getFirstElement();
                    AJAXMonitorPage.this.updateDetails(xhr);
                }
            }
        });
        this.mainControl = hSashForm;
    }

    private void createRequestsTable(Composite parent) {
        this.tableViewer = new TableViewer(parent, 65540);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column = new TableColumn(table, 16384);
        column.setResizable(false);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(20));
        column = new TableColumn(table, 16384);
        column.setText(Messages.AJAXMonitorPage_URL);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        column = new TableColumn(table, 16384);
        column.setText(Messages.AJAXMonitorPage_Method);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        column = new TableColumn(table, 16384);
        column.setText(Messages.AJAXMonitorPage_Sent);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        column = new TableColumn(table, 16384);
        column.setText(Messages.AJAXMonitorPage_Received);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        this.tableViewer.setContentProvider((IContentProvider)new XHRContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new XHRLabelProvider());
    }

    private void createDetailsPart(Composite parent, String name, Viewer[] viewers) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth /= 2;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText(name);
        CTabFolder tab = new CTabFolder(container, 0x800C00);
        tab.setLayoutData((Object)new GridData(1808));
        TableViewer viewer = new TableViewer((Composite)tab, 65540);
        Table table = viewer.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setText(Messages.AJAXMonitorPage_Name);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        column = new TableColumn(table, 16384);
        column.setText(Messages.AJAXMonitorPage_Value);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        viewer.setContentProvider((IContentProvider)new XHRContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new XHRLabelProvider());
        viewers[0] = viewer;
        CTabItem item = new CTabItem(tab, 0);
        item.setControl(viewers[0].getControl());
        item.setText(Messages.AJAXMonitorPage_Headers);
        TextViewer textViewer = new TextViewer((Composite)tab, 776);
        item = new CTabItem(tab, 0);
        item.setControl(textViewer.getControl());
        item.setText(Messages.AJAXMonitorPage_Body);
        textViewer.setEditable(false);
        textViewer.setDocument((IDocument)new Document());
        viewers[1] = textViewer;
        tab.setSelection(item);
    }

    private void updateDetails(IXHRTransfer xhr) {
        if (xhr != null) {
            this.requestData[0].setInput((Object)xhr.getRequestHeaders());
            ((IDocument)this.requestData[1].getInput()).set(xhr.getRequestBody());
            this.responseData[0].setInput((Object)xhr.getResponseHeaders());
            ((IDocument)this.responseData[1].getInput()).set(xhr.getResponseBody());
        } else {
            this.requestData[0].setInput(null);
            ((IDocument)this.requestData[1].getInput()).set("");
            this.responseData[0].setInput(null);
            ((IDocument)this.responseData[1].getInput()).set("");
        }
    }

    public Control getControl() {
        return this.mainControl;
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public Viewer getViewer() {
        return this.tableViewer;
    }
}

